/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.event;

import com.dfdyz.epicacg.client.render.pipeline.PostEffectPipelines;
import com.dfdyz.epicacg.client.screeneffect.ScreenEffectBase;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="epicacg", value={Dist.CLIENT})
public class ScreenEffectEngine {
    static Set<ScreenEffectBase> effects = Sets.newConcurrentHashSet();

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void OnRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            effects.forEach(e -> {
                if (e.shouldPost(event.getCamera(), event.getFrustum())) {
                    PostEffectPipelines.PostEffectQueue.add(e.getPipeline());
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            effects.forEach(ScreenEffectBase::tick);
            effects.removeIf(ScreenEffectBase::shouldRemoved);
        }
    }

    public static void PushScreenEffect(ScreenEffectBase screenEffect) {
        ScreenEffectEngine.effects.removeIf(effects -> effects.ID.equals((Object)screenEffect.ID));
        ScreenEffectEngine.effects.add(screenEffect);
    }
}

